# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 8
# Experiment: PMxPM, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR8_strategy.txt
# LLM Suggested Fallback: C

def velvet_illusionist(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    if current_round <= 3:
        return "C"
    elif current_round <= 7:
        always_c = "return 'C'" in opponent_program_code or "return 'c'" in opponent_program_code
        always_d = "return 'D'" in opponent_program_code or "return 'd'" in opponent_program_code
        if always_c or always_d:
            return "D"
        else:
            if random.random() < 0.3:
                return "D"
            else:
                return opp_history[-1] if opp_history else "C"
    else:
        if sum(1 for move in opp_history if move == "D") >= 3:
            return "D"
        else:
            if random.random() < 0.1:
                return "D"
            else:
                return opp_history[-1] if opp_history else "C"